#!/bin/bash

echo "--- Only Execute Inside Folder Downloaded!"
echo "--- Run using sudo sh deploy.sh"
echo ""
echo ""

if [ `id -u` -ne 0 ]
  then echo Please run this script as root or using sudo!
  exit
fi

SERVICE_NAME="atgomon"
SERVICE_DESCRIPTION="atgomon application service"
USERNAME="atgomon"
GROUPNYA="atgomon"

WORKING_DIRECTORY="/opt/atgomon"
EXECUTABLE_PATH="$WORKING_DIRECTORY/$SERVICE_NAME"
HOSTNYA=$(hostname)

echo "Hostname: $HOSTNYA"

# Get Dirname
DIRNYA="$(pwd)"
echo "DIRNYA: $DIRNYA"

LANJUT=false

# Uninstall Existing
echo ""
sudo systemctl stop "$SERVICE_NAME"
sudo systemctl disable "$SERVICE_NAME"
sudo rm "/etc/systemd/system/$SERVICE_NAME.service"
sudo systemctl daemon-reload
echo "Uninstallation of $SERVICE_NAME completed."

# Remove old Binari
rm -rf $WORKING_DIRECTORY/$SERVICE_NAME
echo ""

    ## Create User if not available for allow suoder without password
    ## user cant use login
    ## user can sudoer without input password
    if [ $(id -u $USERNAME) ]
    then
        echo ""
        echo "User $USERNAME already exists"
    else
        echo ""
        echo "User $USERNAME does not exist"
        sudo useradd -r -s /usr/sbin/nologin $USERNAME
        sudo usermod -a -G tty $USERNAME
        sudo usermod -a -G dialout $USERNAME
        sudo usermod -a -G disk $USERNAME
        sudo usermod -a -G sudo $USERNAME
        sudo usermod -a -G input $USERNAME
        sudo usermod -a -G netdev $USERNAME
        sudo usermod -a -G plugdev $USERNAME
        #Jika ada butuh permisiion next disini utk add ke groupnya
    fi

echo ""
echo ""
echo "Copying/Moving binary to Production"
sudo mkdir $WORKING_DIRECTORY
sudo mv bin/atgomon $WORKING_DIRECTORY/$SERVICE_NAME
sudo mv atgomon $WORKING_DIRECTORY/$SERVICE_NAME
sudo cp install.sh $WORKING_DIRECTORY/
sudo cp uninstall.sh $WORKING_DIRECTORY/
sudo cp usb-restart.sh $WORKING_DIRECTORY/

echo ""
echo "Change Directory to Production"
#change dir to /opt/atgomon

cd $WORKING_DIRECTORY
DIRNYA="$(pwd)"
echo "DIRNYA: $DIRNYA"

LANJUT=true


if [ $DIRNYA = $WORKING_DIRECTORY ]
then
    echo ""
    sudo chown -R $USERNAME:$GROUPNYA $WORKING_DIRECTORY
    sudo chmod +x $WORKING_DIRECTORY/$SERVICE_NAME
    sudo chmod +x $WORKING_DIRECTORY/install.sh
    sudo chmod +x $WORKING_DIRECTORY/uninstall.sh
    sudo chmod +x $WORKING_DIRECTORY/usb-restart.sh

    echo "Install..."
    
    SERVICE_UNIT="[Unit]
    Description=$SERVICE_DESCRIPTION
    Wants=network-online.target
    After=network-online.target

    [Service]
    ExecStart=$EXECUTABLE_PATH
    WorkingDirectory=$WORKING_DIRECTORY
    User=$USERNAME
    Group=$USERNAME
    Restart=always
    RestartSec=10


    [Install]
    WantedBy=multi-user.target"

    echo "$SERVICE_UNIT" | sudo tee "/etc/systemd/system/$SERVICE_NAME.service"
    sudo systemctl enable "$SERVICE_NAME"
    sudo systemctl start "$SERVICE_NAME"

else
    echo "Error -> Dir Location not Valid, Must in :"
    echo "- $WORKING_DIRECTORY"
    echo "user atgomon must be created and sudoer without login and without password"
fi

