#!/bin/bash

SERVICE_NAME="atgomon"
SERVICE_DESCRIPTION="atgomon application service"
USERNAME="atgomon"
GROUPNYA="atgomon"

WORKING_DIRECTORY="/home/atgomon"
EXECUTABLE_PATH="$WORKING_DIRECTORY/$SERVICE_NAME"
HOSTNYA=$(hostname)

echo "Hostname: $HOSTNYA"

# Get Dirname
DIRNYA="$(pwd)"
echo "DIRNYA: $DIRNYA"

LANJUT=false

if [ $DIRNYA = "/home/atgomon" ]
then 
    LANJUT=true
else
    echo "Error -> Dir Location not Valid, Must in :"
    echo "- /home/atgomon"
fi
# # Get Dirname and Up 1 level
# DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
# cd $DIR
# cd ..
# # Get Current Dirname
# CUDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
# echo "Current Dir: $CUDIR"

if [ $LANJUT ]
then 

    ## Create User if not available for allow suoder without password
    ## user cant use login
    ## user can sudoer without input password
    if [ $(id -u $SERVICE_NAME) ]
    then
        echo "User $SERVICE_NAME already exists"
    else
        echo "User $SERVICE_NAME does not exist"
        # sudo useradd -r -s /bin/false $SERVICE_NAME
        sudo useradd -r -s /usr/sbin/nologin $USERNAME
    fi
    
    sudo chown -R $USERNAME:$GROUPNYA $WORKING_DIRECTORY
    sudo chmod +x $WORKING_DIRECTORY/$SERVICE_NAME

    echo "Install..."
    
    SERVICE_UNIT="[Unit]
    Description=$SERVICE_DESCRIPTION
    Wants=network-online.target
    After=network-online.target

    [Service]
    ExecStart=sudo $EXECUTABLE_PATH
    WorkingDirectory=$WORKING_DIRECTORY
    User=$USERNAME
    Group=$USERNAME
    Restart=always
    RestartSec=10


    [Install]
    WantedBy=multi-user.target"

    echo "$SERVICE_UNIT" | sudo tee "/etc/systemd/system/$SERVICE_NAME.service"
    sudo systemctl enable "$SERVICE_NAME"
    sudo systemctl start "$SERVICE_NAME"

fi